--[[
    ExtendedRealLight

    Loads additional attributes for a vehiclePart as well.

	@author: 		BayernGamers
	@date: 			19.03.2025
	@version:		1.0

	History:		v1.0 @19.03.2025 - initial implementation in FS 25
                    ------------------------------------------------------------------------------------------------------
	
	License:        Terms:
                        Usage:
                            Feel free to use this work as-is as long as you adhere to the following terms:
						Attribution:
							You must give appropriate credit to the original author when using this work.
						No Derivatives:
							You may not alter, transform, or build upon this work in any way.
						Usage: 
							The work may be used for personal and commercial purposes, provided it is not modified or adapted.
						Additional Clause:
							This script may not be converted, adapted, or incorporated into any other game versions or platforms except by GIANTS Software.
]]
ExtendedRealLight = {}

function ExtendedRealLight:loadFromXML(xmlFile, baseKey, components, i3dMappings, loadLightTypes)
    if xmlFile:getRootName() == "vehiclePart" then
        self.vehicle:loadAdditionalLightAttributesFromXML(xmlFile, baseKey, self)
    end

    return true
end

function ExtendedRealLight.appendedFunctionKeepBool(oldFunc, newFunc)
	if oldFunc ~= nil then
		return function (...)
			local val1 = oldFunc(...)
			local val2 = newFunc(...)

            return val1 and val2
		end
	else
		return newFunc
	end
end

RealLight.loadFromXML = ExtendedRealLight.appendedFunctionKeepBool(RealLight.loadFromXML, ExtendedRealLight.loadFromXML)
